from django.db.models import fields
from rest_framework import serializers
from .models import projectModel, users_info


class leaderSerializer(serializers.ModelSerializer):
    
    class Meta:
        model = users_info
        fields = ('username','password','email','phone_number','company')
        extra_kwargs = {'password' : {'write_only':True}}

    def create(self, validated_data):
        password = validated_data.pop('password',None)
        instance =self.Meta.model(**validated_data)

        if password is not None :
            instance.set_password(password)
        instance.save()
        return instance


# class projectRegisterSerializer(serializers.ModelSerializer):
    
#     class Meta:
#         model = projectModel
#         fields = ('project_name','company_name')

#     def create(self, validated_data):
#         instance =self.Meta.model(**validated_data)
#         instance.save()
#         return instance