from calendar import c
from random import randint
from unicodedata import name
from urllib import response
from django.shortcuts import render
from django.core.mail import send_mail
from django.conf import settings
from rest_framework.views import APIView

from .models import Codes, projectEmploee, projectModel, users_info
from .serializers import leaderSerializer
from rest_framework.response import Response
from rest_framework import status
from django.contrib.auth.models import Group
from rest_framework.permissions import IsAuthenticated

#####################تابع ارسال ایمیل ###################

def getEmailForSend(user_email, subject, message):
    subject = 'Smart Time : ' + subject
    message = message
    email_from = settings.EMAIL_HOST_USER
    recipient_list = [user_email,]
    try:
        send_mail( subject, message, email_from, recipient_list )
        return '200'
    
    except :
        return 'error'
############################پایان#########################



class leaderRegister(APIView):
    def has_permission(self, request, view):
        if self.action in ('create', ): # for POST method the action in DRF is create
            return True
        return False

    def post(self, request, format='json'):
        serializer = leaderSerializer(data=request.data)
        if serializer.is_valid():
            user = serializer.save()
            company_name = user.company
            company = users_info.objects.filter(company=company_name)
            if company.exists() and len(company)>1 :
                return Response({'status':False,'detail':"company is exist !"})
            
            
            my_group = Group.objects.get(name='leader_of_company') 
            my_group.user_set.add(user)
            new_group, created = Group.objects.get_or_create(name=user.company)
            my_group = Group.objects.get(name=user.company) 
            my_group.user_set.add(user)
            # برای حالتی که یوزر active نشه 
            # user.is_active = False
            # user.save()
            # company_name=user.company
            
            if user:
                json = serializer.data
                return Response( status=status.HTTP_201_CREATED)
        return Response(serializer.errors, status=status.HTTP_400_BAD_REQUEST)

class sendEmail(APIView):
    def post(self, request, *args, **kwargs):
        
        email = request.data.get('email')
        if email:
            # user =str( request.data.get('user'))

            # user = users_info.objects.filter(username=user)
            # if user.exists():
            #     user = user.first()
            # else:
            #     return Response({"status":False,"detail":"user does not exist"})

            code = str(randint(10000,100000))
            print(code)
            code_instance = Codes.objects.filter(email=email)
            if code_instance.exists and len(code_instance)>0 :
                code_instance=code_instance.first()
                code_instance.code = code
                code_instance.save()
            
            else:
                code_instance = Codes(email=email,code = code)     
                code_instance.save()
            # if code_instance . exists():
            #     code_instance= code_instance.first()
            #     code_instance.code = code
            #     code_instance.save()
            # else:
            #     code_instance = Codes(user = user , code = str(code))
            #     code_instance.save()
            getEmailForSend(email,'فعال سازی حساب','کد فعال سازی : ' + str(code))

            return Response(status=status.HTTP_200_OK)
        else:
            return Response(status=status.HTTP_404_NOT_FOUND)


class verifyEmail(APIView):
    def post(self, request, *args, **kwargs):
        code = request.data.get('code')
        email = request.data.get('email')
        # user = users_info.objects.filter(username=str(user))
        
        codeinstance=Codes.objects.filter(email=email)
        
        if codeinstance.exists():
            codeinstance =codeinstance.first()
            if str(codeinstance.code) == str(code):

                return Response(status=status.HTTP_200_OK)
            else:
                return Response(status=status.HTTP_401_UNAUTHORIZED)

           
        else:
            return Response({'status':False , 'detail':"email is not exists "})



#############وارد کردن کارمندان توسط مدیر####################

class employeeRegister(APIView):
    permission_classes = (IsAuthenticated,)

    def post(self, request, *args, **kwargs):   
        company=request.data.get('company') 
        first_name=request.data.get('first_name')
        last_name=request.data.get('last_name')
        phone_number=request.data.get('phone_number')
        email =request.data.get('email')
        password=request.data.get('password')
        
        try:
            user = users_info(first_name= first_name,last_name=last_name,email=email,phone_number=phone_number,username=str(phone_number)+str(company),company=company)
            user.set_password(password)
            user.save()
        except:
            return Response({'status':status.HTTP_403_FORBIDDEN,'detail':"user with phone is exsist"})

        
        my_group = Group.objects.get(name=company) 
        my_group.user_set.add(user)
        return Response(status=status.HTTP_201_CREATED)

    def get(self,request,company_name=None):
        if company_name:
            company_employee=users_info.objects.filter(company=company_name)
            if company_employee.exists():
                company_list=[]
                for i in company_employee:
                    company_list.append((i.first_name,i.last_name))
                
                return Response({"status":status.HTTP_200_OK,"detail":company_list})
                
            else:
                return Response(status=status.HTTP_404_NOT_FOUND)
       

###############ایجاد پروژه برای شرکت##################

class projectRegister(APIView):

    permission_classes = (IsAuthenticated,)


    def put(self, request ,project_name=None,company_name=None):
        user = request.user
        user_leader = users_info.objects.filter(username = str(user),company=str(company_name))

        if user_leader.exists():
            u=user_leader.first()
            project_instance = projectModel(company_name=u,project_name=project_name)
            project_instance.save()
            return Response({'status':status.HTTP_201_CREATED})
        else:
            return Response({'status':status.HTTP_404_NOT_FOUND})

    def get(self,request,company_name=None):

        if company_name:
            user = request.user
            company = users_info.objects.filter(username=user,company=company_name)
            if company.exists():
                project_query=projectModel.objects.filter(company_name=company.first())
                if project_query.exists():
                    project_list = []
                    for i in project_query:
                        project_list.append(i.project_name)
    
                    return Response({'status':status.HTTP_200_OK,'detail':project_list})
                return Response(status=status.HTTP_400_BAD_REQUEST)
            
            else:
                return Response(status=status.HTTP_400_BAD_REQUEST)


    def post(self,request):
        first_name=request.data.get('first_name')
        last_name=request.data.get('last_name')
        company_name=request.data.get('company_name')
        project_name=request.data.get('project_name')
        user=request.user
        if first_name and last_name and company_name and project_name:
            company_instance=users_info.objects.filter(username=user,company=company_name)
            if company_instance.exists():
                company_instance=company_instance.first()

                emploee_instanse=users_info.objects.filter(first_name=first_name,last_name=last_name,company=company_name)
                if emploee_instanse.exists():
                    emploee_instanse=emploee_instanse.first()
                    project_instance=projectModel.objects.filter(project_name=project_name,company_name=company_instance)
                    if project_instance.exists():
                        project_instance=project_instance.first()
                        project_add_instanse=projectEmploee(emploee=emploee_instanse,project_name=project_instance)
                        project_add_instanse.save()
                        return Response({'status':status.HTTP_201_CREATED})

                    else:
                        return Response({'status':status.HTTP_404_NOT_FOUND,'detail':'project not found'})
                else:    
                    return Response({'status':status.HTTP_404_NOT_FOUND,'detail':'emploee not found'})
            else:   
                return Response({'status':status.HTTP_404_NOT_FOUND,'detail':'company not found'})
        else:
            return Response({'status':status.HTTP_404_NOT_FOUND})



