"""smart_time URL Configuration

The `urlpatterns` list routes URLs to views. For more information please see:
    https://docs.djangoproject.com/en/4.0/topics/http/urls/
Examples:
Function views
    1. Add an import:  from my_app import views
    2. Add a URL to urlpatterns:  path('', views.home, name='home')
Class-based views
    1. Add an import:  from other_app.views import Home
    2. Add a URL to urlpatterns:  path('', Home.as_view(), name='home')
Including another URLconf
    1. Import the include() function: from django.urls import include, path
    2. Add a URL to urlpatterns:  path('blog/', include('blog.urls'))
"""
from django.contrib import admin
from django.urls import path
from main_app.views import *

from django.urls import path, include, re_path
from rest_framework_simplejwt import views as jwt_views
  
urlpatterns = [
    path('admin/', admin.site.urls),
    path('api/token/',jwt_views.TokenObtainPairView.as_view(),name ='token_obtain_pair'),
    path('api/token/refresh/',jwt_views.TokenRefreshView.as_view(),name ='token_refresh'),
    # path('rest-auth/', include('rest_auth.urls')),
    path('api/register/',leaderRegister.as_view(), name="create_user"),
    path('api/send_email/',sendEmail.as_view(), name="sendemail"),
    path('api/verify_email/',verifyEmail.as_view(), name="verifyemail"),
    path('api/employee_register/<str:company_name>/',employeeRegister.as_view(), name="employeeRegister"),
    path('api/project_register/<str:company_name>/<str:project_name>/',projectRegister.as_view(), name="projectRegister"),
    path('api/project_register/<str:company_name>/',projectRegister.as_view(), name="projectRegister"),
    path('api/project_register/',projectRegister.as_view(), name="projectRegister"),

    # path('', include('app.urls')),
]

